
#Sourcecode for Elife paper Figure 4
#By Dr Charles Agoti
#Last updated 29 June 2022

#clear workspace, upload packages, specify working directory
## The aim of this plot is to show the lineage temporal introduction patterns

rm(list=ls())
library(tidyverse); library(janitor); library(artyfarty); library(lubridate);library(scales)

Figure_4 <- read.csv("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Data/monthly_detection_trends.csv")%>%
  rename(month=monthdetection,total_by_month=dete_lineage,cummulative_types=cum, new_for_month=monthly)%>%
  pivot_longer(cols =c("total_by_month", "new_for_month"), names_to="lineages", values_to = "count")%>%
  mutate(lineages=factor(lineages, levels=c("total_by_month", "new_for_month")))%>%
  mutate(lineages=fct_recode(lineages, "Number of lineages detected"="total_by_month",
                             "New lineages detected"="new_for_month"))%>%
  mutate(month=as.Date(month))%>%
  ggplot()+
  geom_col(aes(x=month, y=count, fill=lineages), position = "dodge", width = 18)+
  geom_line(aes(x=month, y=cummulative_types/2.5), linetype="dotted", size=0.8, color="red")+
  geom_point(aes(x=month, y=cummulative_types/2.5), shape=1, size=2.5, stroke=0.8, color="red", inherit.aes = T)+
  scale_y_continuous(breaks=seq(0,20, 5), limits = c(0, 20), 
                     sec.axis=sec_axis(~.*2.5, name= "Cummulative number of lineages"))+
  scale_x_date(breaks="1 month", labels=date_format("%b \n%Y"))+
  geom_vline(xintercept = as.Date("2020-09-16"), size=0.25, linetype="longdash", color="black")+
  geom_text(x=as.Date("2020-06-15"), y=20, label="Wave 1", size=4)+
  geom_text(x=as.Date("2020-12-15"), y=20, label="Wave 2", size=4)+
  scale_fill_manual(values=c("#2E9FDF","#AF0076"))+
  labs(x="", y="Number of lineages")+
  theme_scientific()+
  theme(axis.title.x = element_text(size = 12),
        axis.title.y = element_text(size = 12),
        axis.text.x = element_text(size = 12),
        axis.text.y.right = element_text(size = 12, angle=0, color = "red"),
        plot.title = element_text(hjust = 0.5, size = 12, face="bold"),
        #legend.position = "bottom",
        legend.position = c(0.32, 0.8),
        legend.key.size = unit(0.25, "cm"),
        legend.spacing.x = unit(0.20, 'cm'),
        legend.spacing.y = unit(0.20, 'cm'),
        legend.text = element_text(size = 12),
        legend.title =element_text(size = 12),
        strip.background = element_rect(fill="white", color = "white"),
        panel.spacing.x = unit(0.8,"lines"),
        legend.box.background = element_blank())+
  guides(fill=guide_legend(nrow=2, title = "Key", title.position = "top"), size=T)
pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.4/Figure 4.pdf", width=8.5, height = 3.51)
print(Figure_4)
dev.off()
Figure_4
